#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "distances.inc"

global_settings { max_trace_level 10 } 

#declare RingRadius = 5;
#declare RingTRadius = 2*inches;
#declare FenceHeight = 2;
#declare HandleRadiusTop = RingRadius/2.5;
#declare HandleRadiusBot = RingRadius/3.2;
#declare HandleLength = RingRadius*2;
#declare DropHandle = FenceHeight*2.1;
#declare FlameBase = FenceHeight*4;
#declare KnobLength = HandleLength/4;
#declare KnobRadiusBot = HandleRadiusBot*3/4;

#declare rustedCopper = 	texture {
	pigment {
		bozo
		color_map {
			[0.0 rgb <.1, .7, .5>]
			[0.3 rgb <.1, .7, .5>]
			[0.6 rgb <.1, .9, .3>]
			[0.9 rgb <.1, .9, .3>]
			[1.0 rgb <.1, .7, .5>]
		}
	}
	finish {
		//ambient .35
		metallic
		reflection .1
		phong .75
		phong_size 100
	}
	normal {
		crackle .15
		turbulence .15
		scale .1
	}
}
texture {
	pigment {
		bozo
		turbulence .5
		color_map {
			[0.0	rgbt <1,1,1,1>]
			[0.15	rgbt <1,1,1,1>]
			[.2		rgbt <.65,.15,.15,.7>]
			[0.6	rgbt <.65,.15,.15,.4>]
			[1.0	rgbt <.65,.15,.15,.1>]
		}
		scale 2
	}
	normal {
		crackle 1.25
		turbulence .25
		scale .5
	}
//		finish {
//			ambient .3
//		}
}


#declare cupOutline =  lathe {
	cubic_spline 8
	<-17,7>,
	<2,-10>,
	<37,-7>,
	<41,3>,
	<38,10>,
	<36,20>,
	<39,33>,
	<54,65>
	translate <0,-33,0>
	scale <(RingRadius+RingTRadius)/39,(DropHandle+HandleLength*.1)/41, (RingRadius+RingTRadius)/39>
}
#declare cup = difference {
	object { cupOutline }
	object { cupOutline scale .95 }
	#declare Count = 1;
	#declare MaxFruFru = 18;
	#while (Count <= MaxFruFru)
	sphere {
		0,(RingRadius+RingTRadius)*.05*2
		scale <1,1.1,1>
		rotate -15*x
		translate <0,-1,-RingRadius>
		rotate Count*360/MaxFruFru*y
		#declare Count = Count + 1;
	}
	#end
}

#declare FlameMount = cylinder {
	0*y, FlameBase*y,
	(2*HandleRadiusTop+HandleRadiusBot)/3
}

#declare HandleOutline = union {
	cone {
		-HandleLength*y, HandleRadiusBot,
		0, HandleRadiusTop
	}
	torus {
		HandleRadiusTop,HandleRadiusTop/4
		translate -HandleLength*.2*y
	}
	torus {
		HandleRadiusBot,HandleRadiusBot/4
		translate -HandleLength*y
	}

	//BOTTOM KNOB and SHEATH
	cylinder {
		-HandleLength*y, -.88*HandleLength*y,
		HandleRadiusBot*1.1
	}
	cone {
		-HandleLength*y,HandleRadiusBot,
		-(KnobLength+HandleLength)*y, KnobRadiusBot
	}
	sphere {
		-(KnobLength+HandleLength)*y, KnobRadiusBot
	}

	object { FlameMount }
	translate -DropHandle*y
}

#declare Handle = difference {
	object { HandleOutline }
	object { HandleOutline scale <.95,1,.95> }
	object { FlameMount translate -DropHandle*y scale <.95, 1.1, .95> }
}

#declare Torch = union {
	//FENCE
	torus {
		RingRadius,RingTRadius
		translate FenceHeight*y
	}
	#declare Bars = 11;
	#declare BarCount = 1;
	#while (BarCount <= Bars)
	cylinder {
		0, FenceHeight*y, RingTRadius
		translate -RingTRadius*y
		translate -RingRadius*x
		rotate BarCount*360/Bars*y
	}
	#declare BarCount=BarCount+1;
	#end

	//HANDLE and FLAME MOUNT
	object { Handle }
	//CUP
	object { cup }
}

#declare torchSconce = object { Torch 
	texture { rustedCopper }
	scale 2/50
//	rotate <0,0,35>
//	translate <-1,4,0>
}

